*-------------------------------------------------------------------------------
*
*
*				Trumponomics - Relation between tax probabilities and industry valuation in SP500
*
*				Thomas Pellet, Peterson institute for International economics
*
*									  12-06-2017
*
*-------------------------------------------------------------------------------



*-------------------------------------------------------------------------------
*
*					
*									using daily dataset from Stockcharts and Predict It
*
*-------------------------------------------------------------------------------


clear all

*cd "E:\Thomas\Trumponomics\Stata\Industry and tax odds"

use "S&P sub index and tax proba.dta"

set more off

*gen stata date from excel dates


gen statadate = exceldate + td(30dec1899)
format statadate %tdNN/DD/CCYY

*define last varlist on which to apply transformations
local last "r1yr"

foreach var of varlist  sp500-`last' {
	ipolate `var' statadate, gen(ipo_`var')
}

foreach var of varlist  sp500-`last'{
	gen ln`var' = log(`var')
	label variable ln`var' "log `var'"
}

foreach var of varlist  ipo_sp500-ipo_`last'{
	gen ln`var' = log(`var')
	label variable ln`var' "log `var'"
}

local t = 30

gen corptaxcut1718 = corptaxcut2017
replace corptaxcut1718 = corptaxcut033118 if statadate > td(22oct2017)
gen corptaxdummy = 0
replace corptaxdummy = 1 if statadate == td(23oct2017)

forval i = 1(1)`t' { 
	foreach var of varlist lnsp500-ln`last' {
			gen D`var'`i' = ((`var' - `var'[_n - `i']))*100
			label variable D`var'`i' "D`var'`i'"
	}
	foreach var of varlist lnipo_sp500-lnipo_`last' {
			gen D`var'`i' = ((`var' - `var'[_n - `i']))*100
			label variable D`var'`i' "D`var'`i'"
	}
	foreach var of varlist amt2017 carriedinterest2017 corptaxcut033118 corptaxcut2017 devicetaxaca2017 estate2017 indivtaxcut2017 repat2017 shutdown121117 corptaxcut1718 taxhike2017 ipo_r1mo ipo_r3mo ipo_r6mo ipo_r1yr {
		gen D`var'`i' = `var' - `var'[_n - `i']
		label variable D`var'`i' "D`var'`i'"
	}
}

local t = 30
forval i = 1(1)`t' { 
	gen bigchangedummyplus`i' = 0
	replace bigchangedummyplus`i' = 1 if Dcorptaxcut2017`i' > 10
	
	gen bigchangedummy`i' = 0
	replace bigchangedummy`i' = 1 if abs(Dcorptaxcut2017`i') > 10
	
	gen bigchangedummyminus`i' = 0
	replace bigchangedummyminus`i' = 1 if Dcorptaxcut2017`i' < -10

	gen bigchangedummyrepatplus`i' = 0
	replace bigchangedummyrepatplus`i' = 1 if Drepat2017`i' > 10

	gen bigchangedummyrepat`i' = 0
	replace bigchangedummyrepat`i' = 1 if abs(Drepat2017`i') > 10
	
	gen bigchangedummyrepatminus`i' = 0
	replace bigchangedummyrepatminus`i' = 1 if Drepat2017`i' < -10
}


tsset statadate


*Generate monthly dummy

gen H2 = 0

replace H2 = 1 if statadate > td(20nov2017)

gen H2Dcorptaxcut20177 = H2*Dcorptaxcut20177

gen H2Dcorptaxcut201714 = H2*Dcorptaxcut201714

gen monthdummy = month(statadate)
gen quarterdummy = quarter(statadate)
gen yeardummy = year(statadate)

forval i = 1(1)12 { 
	
	gen M`i' = 0
	replace M`i' = 1 if monthdummy == `i' & yeardummy ==2017
	gen M`i'Dcorptaxcut20177 = M`i'*Dcorptaxcut20177
}

forval i = 1(1)4 { 
	
	gen Q`i' = 0
	replace Q`i' = 1 if quarterdummy == `i' & yeardummy ==2017
	gen Q`i'Dcorptaxcut20177 = Q`i'*Dcorptaxcut20177
}


save "dailySP sub index data.dta", replace

